float Fan1 = D3; //Pin, Fan 1
float Fan2 = D4; //Pin, Fan 2

float tempmin = 0; //Minimum temperature that is worth using the fans
float tempmax = 40; //Maximum temperature that is worth using the fans

float FanVal1; //Outpout Fan 1 value
float FanVal2; //Outpout Fan 2 value

int sensorVal; //value of the sensor

void setup() {
  Serial.begin(9600);
}

void loop() {

  //handle extremy cases
  if(sensorVal < tempmin){ //read sensor value and set lower limit cap
    //interrupt warning message
    FanVal1 = 0;
    FanVal2 = 0;
    analogWrite(Fan1, FanVal1); //write the PWM value to the pwm output pin
    analogWrite(Fan2, FanVal2); //write the PWM value to the pwm output pin
    break;
    
  } else  if(sensorVal > tempmax){ //read sensor value and set upper limit cap
       //interrupt warning message
       FanVal1 = 1023;
       FanVal2 = 1023;
       analogWrite(Fan1, FanVal1); //write the PWM value to the pwm output pin
       analogWrite(Fan2, FanVal2); //write the PWM value to the pwm output pin
       break;
    }

  //common cases
  //map and assign pwm values to the fan output 0 to 1023 corresponds to 0 to 100%
  FanVal1 = map(sensorVal, tempmin, tempmax, 0, 1023);
  FanVal2 = map(sensorVal, tempmin, tempmax, 0, 1023);
  
  //write the PWM value to the pwm output pin
  analogWrite(Fan1, FanVal1);
  analogWrite(Fan2, FanVal2);

}
